/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio.siddump;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import libsidplay.common.CPUClock;
import libsidplay.common.SIDListener;
import libsidplay.components.mos6510.IMOS6510Extension;
import sidplay.audio.siddump.Channel;
import sidplay.audio.siddump.Filter;
import sidplay.audio.siddump.SidDumpOutput;

public abstract class SIDDumpExtension
implements SIDListener,
IMOS6510Extension {
    private static final String[] FILTER_NAME = new String[]{"Off", "Low", "Bnd", "L+B", "Hi ", "L+H", "B+H", "LBH"};
    private static final char[] FREQ_TBL_LO = new char[]{'\u0017', '\'', '9', 'K', '_', 't', '\u008a', '\u00a1', '\u00ba', '\u00d4', '\u00f0', '\u000e', '-', 'N', 'q', '\u0096', '\u00be', '\u00e8', '\u0014', 'C', 't', '\u00a9', '\u00e1', '\u001c', 'Z', '\u009c', '\u00e2', '-', '|', '\u00cf', '(', '\u0085', '\u00e8', 'R', '\u00c1', '7', '\u00b4', '9', '\u00c5', 'Z', '\u00f7', '\u009e', 'O', '\n', '\u00d1', '\u00a3', '\u0082', 'n', 'h', 'q', '\u008a', '\u00b3', '\u00ee', '<', '\u009e', '\u0015', '\u00a2', 'F', '\u0004', '\u00dc', '\u00d0', '\u00e2', '\u0014', 'g', '\u00dd', 'y', '<', ')', 'D', '\u008d', '\b', '\u00b8', '\u00a1', '\u00c5', '(', '\u00cd', '\u00ba', '\u00f1', 'x', 'S', '\u0087', '\u001a', '\u0010', 'q', 'B', '\u0089', 'O', '\u009b', 't', '\u00e2', '\u00f0', '\u00a6', '\u000e', '3', ' ', '\u00ff'};
    private static final char[] FREQ_TBL_HI = new char[]{'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0003', '\u0003', '\u0003', '\u0003', '\u0003', '\u0004', '\u0004', '\u0004', '\u0004', '\u0005', '\u0005', '\u0005', '\u0006', '\u0006', '\u0006', '\u0007', '\u0007', '\b', '\b', '\t', '\t', '\n', '\n', '\u000b', '\f', '\r', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0017', '\u0018', '\u001a', '\u001b', '\u001d', '\u001f', ' ', '\"', '$', '\'', ')', '+', '.', '1', '4', '7', ':', '>', 'A', 'E', 'I', 'N', 'R', 'W', '\\', 'b', 'h', 'n', 'u', '|', '\u0083', '\u008b', '\u0093', '\u009c', '\u00a5', '\u00af', '\u00b9', '\u00c4', '\u00d0', '\u00dd', '\u00ea', '\u00f8', '\u00ff'};
    private char[] freqTableLo = new char[FREQ_TBL_LO.length];
    private char[] freqTableHi = new char[FREQ_TBL_HI.length];
    private long frames;
    private long firstframe;
    private float oldNoteFactor = 1.0f;
    private int baseFreq;
    private int baseNote = 176;
    private boolean flowRes;
    private int noteSpacing;
    private int patternSpacing;
    private boolean timeInSeconds = true;
    private final Channel[] channel = new Channel[3];
    private final Channel[] prevChannel = new Channel[3];
    private final Channel[] prevChannel2 = new Channel[3];
    private Filter filter;
    private Filter prevFilter;
    private boolean firstTime;
    private int counter;
    private int rows;
    private int patternNum = 1;
    private int noteNum = 1;
    private final byte[] registers = new byte[32];
    private CPUClock cpuClock;

    public long getFrames() {
        return this.frames;
    }

    public void setFrames(long frames) {
        this.frames = frames;
    }

    public long getFirstFrame() {
        return this.firstframe;
    }

    public void setFirstFrame(long firstFrame) {
        this.firstframe = firstFrame;
    }

    public float getOldNoteFactor() {
        return this.oldNoteFactor;
    }

    public void setOldNoteFactor(float oldNoteFactor) {
        this.oldNoteFactor = oldNoteFactor;
    }

    public int getBaseFreq() {
        return this.baseFreq;
    }

    public void setBaseFreq(int baseFreq) {
        this.baseFreq = baseFreq;
    }

    public int getBaseNote() {
        return this.baseNote;
    }

    public void setBaseNote(int baseNote) {
        this.baseNote = baseNote;
    }

    public boolean getLowRes() {
        return this.flowRes;
    }

    public void setLowRes(boolean lowRes) {
        this.flowRes = lowRes;
    }

    public int getNoteSpacing() {
        return this.noteSpacing;
    }

    public void setNoteSpacing(int noteSpacing) {
        this.noteSpacing = noteSpacing;
    }

    public int getPatternSpacing() {
        return this.patternSpacing;
    }

    public void setPatternSpacing(int patternSpacing) {
        this.patternSpacing = patternSpacing;
    }

    public boolean getTimeInSeconds() {
        return this.timeInSeconds;
    }

    public void setTimeInSeconds(boolean timeInSeconds) {
        this.timeInSeconds = timeInSeconds;
    }

    public void init(CPUClock cpuClock) {
        this.cpuClock = cpuClock;
        this.firstTime = true;
        this.clearChannelStructures();
        this.recalibrateFreqTable();
    }

    public int getMiddleCFreq() {
        return this.freqTableLo[48] | this.freqTableHi[48] << 8;
    }

    @Override
    public void write(int addr, byte data) {
        this.registers[addr & 0x1F] = data;
    }

    @Override
    public void jmpJsr() {
        if (this.firstTime) {
            this.firstTime = false;
            return;
        }
        for (int ch = 0; ch < 3; ++ch) {
            this.channel[ch].read(ch, this.registers);
        }
        this.filter.read(this.registers);
        if (this.frames >= this.firstframe && !this.isAborted()) {
            try {
                int ch;
                SidDumpOutput output = new SidDumpOutput();
                long time = this.frames - this.firstframe;
                output.setTime(this.getTime(time, this.timeInSeconds));
                for (int c = 0; c < 3; ++c) {
                    boolean newnote = false;
                    if (this.channel[c].getWave() >= 16 && 0 != (this.channel[c].getWave() & 1) && (0 == (this.prevChannel2[c].getWave() & 1) || this.prevChannel2[c].getWave() < 16)) {
                        this.prevChannel[c].setNote(-1);
                    }
                    if (this.frames == this.firstframe || this.prevChannel[c].getNote() == -1 || this.channel[c].getFreq() != this.prevChannel[c].getFreq()) {
                        int dist = Integer.MAX_VALUE;
                        int delta = this.channel[c].getFreq() - this.prevChannel2[c].getFreq();
                        output.setFreq(String.format("%04X", this.channel[c].getFreq()), c);
                        if (this.channel[c].getWave() >= 16) {
                            for (int d = 0; d < 96; ++d) {
                                int cmpfreq = this.freqTableLo[d] | this.freqTableHi[d] << 8;
                                int freq = this.channel[c].getFreq();
                                if (Math.abs(freq - cmpfreq) >= dist) continue;
                                dist = Math.abs(freq - cmpfreq);
                                if (d == this.prevChannel[c].getNote()) {
                                    dist = (int)((float)dist / this.oldNoteFactor);
                                }
                                this.channel[c].setNote(d);
                            }
                            if (this.channel[c].getNote() != this.prevChannel[c].getNote()) {
                                if (this.prevChannel[c].getNote() == -1) {
                                    if (this.flowRes) {
                                        newnote = true;
                                    }
                                    output.setNote(this.channel[c].getNote(false), c);
                                } else {
                                    output.setNote(this.channel[c].getNote(true), c);
                                }
                            } else if (delta != 0) {
                                if (delta > 0) {
                                    output.setNote(String.format("(+ %04X)", delta), c);
                                } else {
                                    output.setNote(String.format("(- %04X)", -delta), c);
                                }
                            } else {
                                output.setNote(" ... .. ", c);
                            }
                        } else {
                            output.setNote(" ... .. ", c);
                        }
                    } else {
                        output.setFreq("....", c);
                        output.setNote(" ... .. ", c);
                    }
                    if (this.frames == this.firstframe || newnote || this.channel[c].getWave() != this.prevChannel[c].getWave()) {
                        output.setWf(String.format("%02X", this.channel[c].getWave()), c);
                    } else {
                        output.setWf("..", c);
                    }
                    if (this.frames == this.firstframe || newnote || this.channel[c].getAdsr() != this.prevChannel[c].getAdsr()) {
                        output.setAdsr(String.format("%04X", this.channel[c].getAdsr()), c);
                    } else {
                        output.setAdsr("....", c);
                    }
                    if (this.frames == this.firstframe || newnote || this.channel[c].getPulse() != this.prevChannel[c].getPulse()) {
                        output.setPul(String.format("%03X", this.channel[c].getPulse()), c);
                        continue;
                    }
                    output.setPul("...", c);
                }
                if (this.frames == this.firstframe || this.filter.getCutoff() != this.prevFilter.getCutoff()) {
                    output.setFcut(String.format("%04X", this.filter.getCutoff()));
                } else {
                    output.setFcut("....");
                }
                if (this.frames == this.firstframe || this.filter.getCtrl() != this.prevFilter.getCtrl()) {
                    output.setRc(String.format("%02X", this.filter.getCtrl()));
                } else {
                    output.setRc("..");
                }
                if (this.frames == this.firstframe || (this.filter.getType() & 0x70) != (this.prevFilter.getType() & 0x70)) {
                    output.setTyp(FILTER_NAME[this.filter.getType() >> 4 & 7]);
                } else {
                    output.setTyp("...");
                }
                if (this.frames == this.firstframe || (this.filter.getType() & 0xF) != (this.prevFilter.getType() & 0xF)) {
                    output.setV(String.format("%01X", this.filter.getType() & 0xF));
                } else {
                    output.setV(".");
                }
                if (!this.flowRes || 0L == (this.frames - this.firstframe) % (long)this.noteSpacing) {
                    this.add(output);
                    for (ch = 0; ch < 3; ++ch) {
                        this.prevChannel[ch].assign(this.channel[ch]);
                    }
                    this.prevFilter.assign(this.filter);
                }
                for (ch = 0; ch < 3; ++ch) {
                    this.prevChannel2[ch].assign(this.channel[ch]);
                }
                if (this.noteSpacing != 0) {
                    ++this.counter;
                    if (this.counter >= this.noteSpacing) {
                        this.counter = 0;
                        if (this.patternSpacing != 0) {
                            ++this.rows;
                            if (this.rows >= this.patternSpacing) {
                                this.rows = 0;
                                this.noteNum = 1;
                                this.addPatternSpacing(this.patternNum++);
                            } else if (!this.flowRes) {
                                this.addNoteSpacing(this.noteNum++);
                            }
                        } else if (!this.flowRes) {
                            this.addNoteSpacing(this.noteNum++);
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ++this.frames;
    }

    private String getTime(long timeInFrames, boolean timeInSeconds) {
        if (!timeInSeconds) {
            return String.format("%5d", timeInFrames);
        }
        return new SimpleDateFormat("m:ss.SSS").format(new Date((long)((double)(timeInFrames * 1000L) / this.cpuClock.getScreenRefresh())));
    }

    private void addNoteSpacing(int noteNum) throws IOException {
        SidDumpOutput noteSep = new SidDumpOutput();
        noteSep.setTime(String.format("-N%03X", noteNum));
        for (int c = 0; c < 3; ++c) {
            noteSep.setFreq("----", c);
            noteSep.setNote("--------", c);
            noteSep.setWf("--", c);
            noteSep.setAdsr("----", c);
            noteSep.setPul("---", c);
        }
        noteSep.setFcut("----");
        noteSep.setRc("--");
        noteSep.setTyp("---");
        noteSep.setV("-");
        this.add(noteSep);
    }

    private void addPatternSpacing(int patternNum) throws IOException {
        SidDumpOutput patternSep = new SidDumpOutput();
        patternSep.setTime(String.format("=P%03X", patternNum));
        for (int c = 0; c < 3; ++c) {
            patternSep.setFreq("====", c);
            patternSep.setNote("========", c);
            patternSep.setWf("==", c);
            patternSep.setAdsr("====", c);
            patternSep.setPul("===", c);
        }
        patternSep.setFcut("====");
        patternSep.setRc("==");
        patternSep.setTyp("===");
        patternSep.setV("=");
        this.add(patternSep);
    }

    private void clearChannelStructures() {
        for (int ch = 0; ch < 3; ++ch) {
            this.channel[ch] = new Channel();
            this.prevChannel[ch] = new Channel();
            this.prevChannel2[ch] = new Channel();
        }
        this.filter = new Filter();
        this.prevFilter = new Filter();
        this.frames = 0L;
        this.counter = 0;
        this.rows = 0;
        if (this.flowRes && 0 == this.noteSpacing) {
            this.flowRes = false;
        }
    }

    private void recalibrateFreqTable() {
        System.arraycopy(FREQ_TBL_LO, 0, this.freqTableLo, 0, FREQ_TBL_LO.length);
        System.arraycopy(FREQ_TBL_HI, 0, this.freqTableHi, 0, FREQ_TBL_HI.length);
        if (this.baseFreq != 0) {
            this.baseNote &= 0x7F;
            if (this.baseNote < 0 || this.baseNote > 96) {
                System.err.println("Warning: Calibration note out of range. Aborting recalibration.");
            } else {
                for (int c = 0; c < 96; ++c) {
                    double note = c - this.baseNote;
                    double freq = (double)this.baseFreq * Math.pow(2.0, note / 12.0);
                    int f = (int)freq;
                    if (freq > 65535.0) {
                        freq = 65535.0;
                    }
                    this.freqTableLo[c] = (char)(f & 0xFF);
                    this.freqTableHi[c] = (char)(f >> 8);
                }
            }
        }
    }

    public abstract boolean isAborted();

    public abstract void add(SidDumpOutput var1) throws IOException;

    public String toHeaderString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("Middle C frequency is $%04X\n", this.getMiddleCFreq()));
        builder.append("\n");
        builder.append(String.format("| Frame | Freq Note/Abs WF ADSR Pul | Freq Note/Abs WF ADSR Pul | Freq Note/Abs WF ADSR Pul | FCut RC Typ V |\n", new Object[0]));
        builder.append(String.format("+-------+---------------------------+---------------------------+---------------------------+---------------+\n", new Object[0]));
        return builder.toString();
    }
}

